<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Real Estate - Find Your Dream Property</title>
    
    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        .hero-bg {
            background-image: url('https://images.unsplash.com/photo-1568605114967-8130f3a36994?q=80&w=2070&auto=format&fit=crop');
        }
    </style>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper/swiper-bundle.min.css" />
<script src="https://cdn.jsdelivr.net/npm/swiper/swiper-bundle.min.js"></script>

</head>
<body class="bg-gray-50">

{{-- Include the new menu --}}
@include('partials.menu')

<main>
    <section class="hero-bg bg-cover bg-center h-[60vh] text-white">
        <div class="bg-black bg-opacity-50 h-full flex flex-col justify-center items-center text-center p-4">
            <h1 class="text-4xl md:text-6xl font-bold mb-4">Your Next Property is a Click Away</h1>
            <p class="text-lg md:text-xl mb-8">Find your dream home, apartment, or office space with ease.</p>
            
            <div class="w-full max-w-3xl bg-white rounded-lg shadow-lg overflow-hidden">
                <!-- Tabs for Buy/Rent/Commercial -->
                <div class="flex border-b border-gray-200">
                    <button onclick="switchTab('buy')" id="tab-buy" class="flex-1 px-6 py-4 text-gray-700 font-semibold border-b-2 border-blue-600 bg-gray-50">
	    Buy
	</button>
	<button onclick="switchTab('rent')" id="tab-rent" class="flex-1 px-6 py-4 text-gray-600 font-semibold border-b-2 border-transparent hover:bg-gray-50">
	    Rent
	</button>
	<button onclick="switchTab('commercial')" id="tab-commercial" class="flex-1 px-6 py-4 text-gray-600 font-semibold border-b-2 border-transparent hover:bg-gray-50">
	    Commercial
	</button>
                </div>
                
                <!-- Search Form -->
                <form class="p-6" id="search-form" method="GET" action="{{ route('property.search') }}">
    <div class="flex flex-col md:flex-row gap-4">
        <!-- City Dropdown -->
        <div class="flex-1">
            <select id="city-select" name="city" class="w-full px-4 py-3 text-gray-800 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 bg-white">
                <option value="">Select City</option>
                <option value="guwahati">Guwahati</option>
                <option value="mumbai">Mumbai</option>
                <option value="delhi">Delhi</option>
                <option value="bangalore">Bangalore</option>
                <option value="pune">Pune</option>
                <option value="hyderabad">Hyderabad</option>
                <option value="chennai">Chennai</option>
                <option value="kolkata">Kolkata</option>
            </select>
        </div>
        
        <!-- Search Input -->
        <div class="flex-1">
            <input type="text" name="q" id="search-input" placeholder="Search by Locality, Project, or Landmark..." class="w-full px-4 py-3 text-gray-800 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" />
        </div>
        
        <!-- Search Button -->
        <button type="submit" class="w-full md:w-auto bg-blue-600 text-white font-bold py-3 px-8 rounded-md hover:bg-blue-700 transition duration-300 flex items-center justify-center gap-2">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
            </svg>
            Search
        </button>
    </div>
    <input type="hidden" id="property-type" name="property_type" value="buy" />
</form>

            </div>
        </div>
    </section>
    
    <div class="max-w-7xl mx-auto px-4">
  <div class="flex flex-col lg:flex-row gap-8">
    <!-- Main content section -->
    <div class="flex-1 w-full">

<!-- FEATURED PROPERTIES - SMALL CARDS -->
<section class="py-10 bg-white">
    <div class="container mx-auto px-4">
        <h2 class="text-2xl font-bold text-center text-gray-800 mb-3">Featured Projects</h2>
        <p class="text-center text-gray-500 mb-6 text-sm">Handpicked projects by our team of experts.</p>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
            @foreach($saleProperties as $project)
            <div class="bg-white rounded-xl shadow border hover:shadow-lg transition overflow-hidden flex flex-col w-full max-w-xs mx-auto">
                <a href="{{ route('project.show', $project->id) }}" class="block flex-1 no-underline">
                    <img src="{{ optional($project->images->first())->image_url ?? '/default-image.jpg' }}" alt="{{ $project->name }}" class="h-32 w-full object-cover" />
                    <div class="p-3">
                        <div class="font-semibold text-[16px] leading-5 mb-0.5 truncate">{{ $project->name }}</div>
                        <div class="text-xs text-gray-500 mb-1">by {{ $project->builder ?? '-' }}</div>
                        <div class="font-medium text-xs mb-1">{{ $project->configurations }}</div>
                        <div class="text-xs text-gray-600 mb-1 truncate">
                            {{ $project->location ?? $project->city }}, {{ $project->state ?? 'N/A' }}
                        </div>
                        <div class="text-lg font-bold text-gray-900 mt-2">
                            ₹{{ number_format($project->min_price/100000, 2) }} Cr - ₹{{ number_format($project->max_price/100000, 2) }} Cr
                        </div>
                    </div>
                </a>
                <div class="flex gap-2 px-3 pb-2 pt-1">
                    @auth
                        <button class="text-red-500 hover:text-red-700" onclick="likeProject({{ $project->id }})" title="Like">
                            <!-- Like Icon SVG -->
                        </button>
                        <button class="text-blue-600 hover:text-blue-800" onclick="favoriteProject({{ $project->id }})" title="Favorite">
                            <!-- Favorite Icon SVG -->
                        </button>
                    @else
                        <button class="text-red-400" onclick="showLoginPrompt()" title="Like">
                            <!-- Like Icon SVG -->
                        </button>
                        <button class="text-blue-400" onclick="showLoginPrompt()" title="Favorite">
                            <!-- Favorite Icon SVG -->
                        </button>
                    @endauth
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>


<!-- SERVICES PROVIDE SECTION -->
<section class="py-8 bg-[#fafbfc]">
  <div class="max-w-5xl mx-auto text-center">
    <h2 class="text-2xl font-bold text-center text-gray-800 mb-3">Services Provide</h2>
    <div class="w-28 border-t-2 border-gray-400 mx-auto mb-10"></div>
    <div class="swiper mySwiper">
      <div class="swiper-wrapper">
        <!-- Service Card Slide -->
        <div class="swiper-slide flex flex-col items-center">
          <a href="/home-loan" class="block">
            <img src="/images/1.png" alt="Home Loan" class="rounded-xl shadow w-[400px] h-[280px] object-contain mx-auto" />
          </a>
        </div>
        <div class="swiper-slide flex flex-col items-center">
          <a href="/architech" class="block">
            <img src="/images/2.png" alt="Arch & Interior" class="rounded-xl shadow w-[400px] h-[280px] object-contain mx-auto" />
          </a>
        </div>
        <div class="swiper-slide flex flex-col items-center">
          <a href="/vastu-shastra" class="block">
            <img src="/images/3.png" alt="Vastu" class="rounded-xl shadow w-[400px] h-[280px] object-contain mx-auto" />
          </a>
        </div>
        <!-- Add more slides if needed -->
      </div>
      <!-- Optional navigation -->
      <div class="swiper-pagination"></div>
      <div class="swiper-button-next"></div>
      <div class="swiper-button-prev"></div>
    </div>
  </div>
</section>



<!-- Cities Slider Section -->
<section class="py-8 bg-[#fafbfc]">
  <div class="max-w-7xl mx-auto px-4">
    <h2 class="text-2xl font-bold text-center text-gray-800 mb-3">Cities</h2>
    <div class="w-28 border-t-2 border-gray-400 mx-auto mb-10"></div>
    <!-- City Names Slider (full width above columns) -->
    <div class="swiper myCitySwiper mb-10">
      <div class="swiper-wrapper">
        @foreach(['Agartala','Dibrugarh','Guwahati','Jaipur','Jorhat','Kolkata','Nagaon','Shillong','Siliguri','Tezpur'] as $city)
        <div class="swiper-slide">
          <div class="rounded-xl shadow px-6 py-5 bg-white text-indigo-700 font-bold text-lg flex items-center justify-center transition duration-300 hover:bg-indigo-50 hover:text-indigo-900">
            {{ $city }}
          </div>
        </div>
        @endforeach
      </div>
      <div class="swiper-pagination"></div>
      <div class="swiper-button-next"></div>
      <div class="swiper-button-prev"></div>
    </div>
  </div>
</section>


<!-- NEW PROJECTS SECTION - SMALL CARDS -->
<section class="py-10 bg-white">
    <div class="container mx-auto px-4">
        <h2 class="text-2xl font-bold text-center text-gray-800 mb-3">Latest Projects</h2>
        <p class="text-center text-gray-500 mb-6 text-sm">Explore our recently launched residential & commercial projects.</p>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
            @foreach($latestProjects as $project)
            <div class="group bg-white rounded-xl shadow border hover:shadow-lg transition overflow-hidden flex flex-col w-full max-w-xs mx-auto">
                <a href="{{ route('project.show', $project->id) }}" class="block flex-1 no-underline text-inherit">
                    <div class="relative">
                        <img src="{{ optional($project->images->first())->image_url ?? '/default-image.jpg' }}" alt="{{ $project->name }}" class="w-full h-32 object-cover" />
                        <span class="absolute top-2 left-2 bg-green-500 text-white px-2 py-0.5 rounded-full text-xs font-semibold">
                            New Launch
                        </span>
                    </div>
                    <div class="p-3">
                        <div class="font-semibold text-[16px] leading-5 mb-0.5 truncate">{{ $project->name }}</div>
                        <div class="text-xs text-gray-500 mb-1">by {{ $project->builder ?? '-' }}</div>
                        <div class="font-medium text-xs mb-1">{{ $project->configurations }}</div>
                        <div class="text-xs text-gray-600 mb-1 truncate">
                            {{ $project->location ?? $project->address ?? '' }}, {{ $project->city }}
                        </div>
                        <div class="text-lg font-bold text-gray-900 mt-2">
                            ₹{{ number_format($project->min_price/100000, 2) }} Cr - ₹{{ number_format($project->max_price/100000, 2) }} Cr
                        </div>
                    </div>
                </a>
                <div class="flex gap-2 px-3 pb-2 pt-1">
                    @auth
                        <button class="text-red-500 hover:text-red-700" onclick="likeProperty({{ $project->id }})" title="Like"></button>
                        <button class="text-blue-600 hover:text-blue-800" onclick="favoriteProperty({{ $project->id }})" title="Favorite"></button>
                    @else
                        <button class="text-red-400" onclick="showLoginPrompt()" title="Like"></button>
                        <button class="text-blue-400" onclick="showLoginPrompt()" title="Favorite"></button>
                    @endauth
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>



    <!-- PROPERTIES FOR RENT SECTION -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-6">
        <div class="flex justify-between items-center mb-8">
            <div>
                <h2 class="text-2xl font-bold text-center text-gray-800 mb-3">Properties for Rent</h2>
                <p class="text-gray-500 mt-1">Find your perfect rental home</p>
            </div>
            <a href="{{ route('properties.rent') }}" class="text-blue-600 font-semibold hover:text-blue-700 flex items-center gap-2">
                View All
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </a>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
            @foreach($rentProperties as $property)
                <div class="group relative bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300 flex flex-col">
                    <a href="{{ route('property.show', $property->id) }}" class="block flex flex-col flex-1 no-underline text-inherit">
                        <img src="{{ $property->main_image_url }}" alt="{{ $property->title }}" class="w-full h-32 object-cover" />
                        <div class="p-2 flex flex-col flex-1">
                            <div class="font-semibold text-[16px] leading-5 mb-0.5 truncate">{{ $property->title }}</div>
                            <p class="text-gray-600 text-sm mb-2">📍 {{ $property->address }}, {{ $property->city }}</p>
                            <p class="text-sm text-blue-800">₹{{ number_format($property->price) }}<span class="text-sm text-gray-500">/month</span></p>
                            <div class="flex gap-3 text-xs text-gray-600 mt-2 mb-4">
                                <span>🛏️ {{ $property->bedrooms }} Beds</span>
                                <span>🛁 {{ $property->bathrooms }} Baths</span>
                                <span>📏 {{ number_format($property->area_sqft) }} sqft</span>
                            </div>
                        </div>
                    </a>
                    <div class="mt-auto flex justify-between items-center gap-2 pt-0">
                        @auth
                            <button
                                class="flex items-center gap-1 text-red-500 px-3 py-2 rounded hover:bg-red-100 transition"
                                onclick="likeProperty({{ $property->id }})"
                            >
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M3.172 5.172a4 4 0 015.656 0L10 6.343l1.172-1.171a4 4 0 115.656 5.656L10 18l-6.828-6.828a4 4 0 010-5.656z" />
                                </svg>
                                <span>Like</span>
                            </button>
                            <button
                                class="flex items-center gap-1 text-blue-600 px-3 py-2 rounded hover:bg-blue-100 transition"
                                onclick="favoriteProperty({{ $property->id }})"
                            >
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7" />
                                </svg>
                                <span>Favorite</span>
                            </button>
                        @else
                            <button
                                class="flex items-center gap-1 text-red-500 px-3 py-2 rounded hover:bg-red-100 transition"
                                onclick="showLoginPrompt()"
                            >
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M3.172 5.172a4 4 0 015.656 0L10 6.343l1.172-1.171a4 4 0 115.656 5.656L10 18l-6.828-6.828a4 4 0 010-5.656z" />
                                </svg>
                                <span>Like</span>
                            </button>
                            <button
                                class="flex items-center gap-1 text-blue-600 px-3 py-2 rounded hover:bg-blue-100 transition"
                                onclick="showLoginPrompt()"
                            >
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7" />
                                </svg>
                                <span>Favorite</span>
                            </button>
                        @endauth
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

<section class="bg-white rounded-xl shadow-lg p-6 max-w-7xl mx-auto">
  <div>
    <div class="mb-6">
      <strong class="text-2xl font-bold text-center text-gray-800 mb-3">Everything you Need at One Place</strong>
    </div>

    <div>
      <!-- Tabs -->
      <ul class="flex border-b border-gray-300 mb-6" role="tablist">
        <li class="mr-8">
          <button class="pb-2 border-b-4 border-indigo-600 text-indigo-600" type="button" role="tab" aria-selected="true" aria-controls="tab-item-0" id="tab-0" data-tab-target="#tab-item-0">
            For Buyers / Owners
          </button>
        </li>
        <li class="mr-8">
          <button class="pb-2 border-b-4 border-transparent text-gray-600 hover:text-indigo-600 hover:border-indigo-600" type="button" role="tab" aria-selected="false" aria-controls="tab-item-1" id="tab-1" data-tab-target="#tab-item-1">
            For Tenants
          </button>
        </li>
        <li class="mr-8">
          <button class="pb-2 border-b-4 border-transparent text-gray-600 hover:text-indigo-600 hover:border-indigo-600" type="button" role="tab" aria-selected="false" aria-controls="tab-item-2" id="tab-2" data-tab-target="#tab-item-2">
            For Agents
          </button>
        </li>
        <li>
          <button class="pb-2 border-b-4 border-transparent text-gray-600 hover:text-indigo-600 hover:border-indigo-600" type="button" role="tab" aria-selected="false" aria-controls="tab-item-3" id="tab-3" data-tab-target="#tab-item-3">
            For Builders & Banks
          </button>
        </li>
      </ul>

      <!-- Tab Panels -->
      <div id="tab-item-0" role="tabpanel" aria-labelledby="tab-0" class="block">
        <ul class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-6">
          <li>
            <a href="#" target="_blank" rel="noopener" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Home Loan Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/home-loan.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Home Loan</strong>
            </a>
          </li>
          <li>
            <a href="#" target="_blank" rel="noopener" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Home Interior Design Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/home-interior.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Home Interior Design</strong>
            </a>
          </li>
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Valuation Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/valuation.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Valuation</strong>
            </a>
          </li>
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Vastu Calculator Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/vastu-calculator.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Vastu Calculator</strong>
            </a>
          </li>
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Property Management Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/property-management.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Property Management</strong>
            </a>
          </li>
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Sell or Rent Property Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/sell-or-rent-property.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Sell or Rent Property</strong>
            </a>
          </li>
        </ul>
      </div>

      <div id="tab-item-1" role="tabpanel" aria-labelledby="tab-1" class="hidden">
        <ul class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-6">
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Online Rent Agreement Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/online-rent-agreement.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Online Rent Agreement</strong>
            </a>
          </li>
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Rent Receipts Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/rent-receipts.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Rent Receipts</strong>
            </a>
          </li>
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Property Management Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/property-management.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Property Management</strong>
            </a>
          </li>
        </ul>
      </div>

      <div id="tab-item-2" role="tabpanel" aria-labelledby="tab-2" class="hidden">
        <ul class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-6">
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="List Property With Us Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/advertise-with-us.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">List Property With Us</strong>
            </a>
          </li>
          <li>
            <a href="#" target="_blank" rel="noopener" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Co-Broking For New Projects Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/co-broking-for-new-projects.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Co-Broking For New Projects</strong>
            </a>
          </li>
        </ul>
      </div>

      <div id="tab-item-3" role="tabpanel" aria-labelledby="tab-3" class="hidden">
        <ul class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-6">
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Advertise With Us Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/advertise-with-us.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Advertise With Us</strong>
            </a>
          </li>
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="3D/AR/VR Services Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/three-d-services.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">3D/AR/VR Services</strong>
            </a>
          </li>
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Data Intelligence Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/data-intelligence.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Data Intelligence</strong>
            </a>
          </li>
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Mortgage Partnerships Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/mortgage-partnerships.png" class="rounded-lg" />
              <strong class="text-center text-md font-semibold">Mortgage Partnerships</strong>
            </a>
          </li>
          <li>
            <a href="#" class="flex flex-col items-center space-y-3 hover:text-indigo-600">
              <img alt="Super Agent Pro Icon" width="64" height="64" src="https://www.squareyards.com/assets/images/squareyard-services/super-agent-pro.png" class="rounded-lg" />
              <strong class="text-center text-lg font-semibold">Super Agent Pro</strong>
            </a>
          </li>
        </ul>
      </div>
    </div>
  </div>

</section>



<!-- FEATURED PROPERTIES FOR SALE -->
<section class="py-16 bg-gray-100">
    <div class="container mx-auto px-6">
        <div class="flex justify-between items-center mb-8">
            <div>
                <h2 class="text-2xl font-bold text-center text-gray-800 mb-3">Properties for Sale</h2>
                <p class="text-gray-500 mt-1">Find your dream home to buy</p>
            </div>
            <a href="{{ route('properties.sale') }}" class="text-blue-600 font-semibold hover:text-blue-700 flex items-center gap-2">
                View All
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
            </a>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
            @foreach($saleProperties as $property)
                <div class="group relative bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300 flex flex-col">
                    <a href="{{ route('property.show', $property->id) }}" class="block no-underline text-inherit flex flex-col flex-1">
                        <img src="{{ $property->main_image_url }}" alt="{{ $property->title }}" class="w-full h-32 object-cover" />
                        <div class="p-2 flex flex-col flex-1">
                            <div class="font-semibold text-[16px] leading-5 mb-0.5 truncate">{{ $property->title }}</div>
                            <p class="text-gray-600 text-sm mb-2">📍 {{ $property->address }}, {{ $property->city }}</p>
                            <p class="text-sm text-blue-800">₹{{ number_format($property->price) }}</p>
                            <div class="flex gap-3 text-xs text-gray-600 mt-2 mb-4">
                                <span>🛏️ {{ $property->bedrooms }} Beds</span>
                                <span>🛁 {{ $property->bathrooms }} Baths</span>
                                <span>📏 {{ number_format($property->area_sqft) }} sqft</span>
                            </div>
                        </div>
                    </a>
                    <div class="mt-auto flex justify-between items-center gap-2 pt-0">
                        @auth
                            <button
                                class="flex items-center gap-1 text-red-500 px-3 py-2 rounded hover:bg-red-100 transition"
                                onclick="likeProperty({{ $property->id }})"
                            >
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M3.172 5.172a4 4 0 015.656 0L10 6.343l1.172-1.171a4 4 0 115.656 5.656L10 18l-6.828-6.828a4 4 0 010-5.656z" />
                                </svg>
                                <span>Like</span>
                            </button>
                            <button
                                class="flex items-center gap-1 text-blue-600 px-3 py-2 rounded hover:bg-blue-100 transition"
                                onclick="favoriteProperty({{ $property->id }})"
                            >
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7" />
                                </svg>
                                <span>Favorite</span>
                            </button>
                        @else
                            <button
                                class="flex items-center gap-1 text-red-500 px-3 py-2 rounded hover:bg-red-100 transition"
                                onclick="showLoginPrompt()"
                            >
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M3.172 5.172a4 4 0 015.656 0L10 6.343l1.172-1.171a4 4 0 115.656 5.656L10 18l-6.828-6.828a4 4 0 010-5.656z" />
                                </svg>
                                <span>Like</span>
                            </button>
                            <button
                                class="flex items-center gap-1 text-blue-600 px-3 py-2 rounded hover:bg-blue-100 transition"
                                onclick="showLoginPrompt()"
                            >
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 15l7-7 7 7" />
                                </svg>
                                <span>Favorite</span>
                            </button>
                        @endauth
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>


    <!-- POST YOUR PROPERTY SECTION (Call-to-Action) -->
    <section class="py-16 bg-gradient-to-r from-blue-600 to-blue-700 text-white">
        <div class="container mx-auto px-6">
            <div class="flex flex-col md:flex-row items-center justify-between gap-8">
                <div class="flex-1">
                    <h2 class="text-2xl md:text-4xl font-bold mb-4">Want to List Your Property?</h2>
                    <p class="text-lg text-blue-100 mb-6">
                        Post your property for FREE and reach thousands of potential buyers and tenants across India. 
                        Get genuine leads and close deals faster.
                    </p>
                    <ul class="space-y-3 mb-6">
                        <li class="flex items-center gap-3">
                            <svg class="w-6 h-6 text-green-300" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                            </svg>
                            <span>100% FREE - No hidden charges</span>
                        </li>
                        <li class="flex items-center gap-3">
                            <svg class="w-6 h-6 text-green-300" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                            </svg>
                            <span>Reach verified buyers & tenants</span>
                        </li>
                        <li class="flex items-center gap-3">
                            <svg class="w-6 h-6 text-green-300" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                            </svg>
                            <span>Get expert assistance</span>
                        </li>
                    </ul>
                </div>
                
                <div class="flex-shrink-0">
                    <a href="{{ route('register') }}" class="inline-block bg-white text-blue-600 font-bold px-8 py-4 rounded-lg hover:bg-gray-100 transition duration-300 shadow-lg text-lg">
                        Post Property FREE
                        <span class="ml-2">→</span>
                    </a>
                    <p class="text-sm text-blue-100 mt-3 text-center">Takes less than 2 minutes</p>
                </div>
            </div>
        </div>
    </section>
    
    
<div id="DEMAND_CARD" class="p-6 bg-white rounded-lg shadow-lg max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div id="DEMAND_CARD_TITLE" class="text-lg font-semibold mb-1">
        Cities
    </div>
    <div id="DEMAND_CARD_SUBTITLE" class="text-sm text-gray-500 mb-6">
        Popular localities searched
    </div>

    @php
        $cities = [
            ['name' => 'Beltola',         'percentage' => 40],
            ['name' => 'Kahilipara',      'percentage' => 25],
            ['name' => 'Lokhra',          'percentage' => 18],
            ['name' => 'VIP Road',        'percentage' => 15],
            ['name' => 'Jalukbari',       'percentage' => 12],
            ['name' => 'Dharapur',        'percentage' => 10],
            ['name' => 'Ganeshguri',      'percentage' => 9],
            ['name' => 'Zoo Road',        'percentage' => 8],
        ];

        $citiesLeft = array_slice($cities, 0, 4);
        $citiesRight = array_slice($cities, 4, 4);
    @endphp

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Left Column -->
        <div>
            @foreach($citiesLeft as $index => $city)
            <div class="mb-4 flex items-center justify-between">
                <div class="flex-1 flex items-center gap-3 min-w-0">
                    <span class="text-gray-600 font-semibold w-6">{{ '#' . ($index + 1) }}</span>
                    <span class="text-blue-700 font-semibold truncate">{{ $city['name'] }}</span>
                </div>
                <div class="flex-1 mx-4">
                    <div class="w-full bg-gray-200 rounded h-3 overflow-hidden">
                        <div class="bg-blue-300 h-3" style="width: {{ $city['percentage'] }}%"></div>
                    </div>
                </div>
                <div class="w-16 text-right text-gray-700 font-semibold text-sm">{{ $city['percentage'] }}% Searches</div>
            </div>
            @endforeach
        </div>
        <!-- Right Column -->
        <div>
            @foreach($citiesRight as $index => $city)
            <div class="mb-4 flex items-center justify-between">
                <div class="flex-1 flex items-center gap-3 min-w-0">
                    <span class="text-gray-600 font-semibold w-6">{{ '#' . ($index + 5) }}</span>
                    <span class="text-blue-700 font-semibold truncate">{{ $city['name'] }}</span>
                </div>
                <div class="flex-1 mx-4">
                    <div class="w-full bg-gray-200 rounded h-3 overflow-hidden">
                        <div class="bg-blue-300 h-3" style="width: {{ $city['percentage'] }}%"></div>
                    </div>
                </div>
                <div class="w-16 text-right text-gray-700 font-semibold text-sm">{{ $city['percentage'] }}% Searches</div>
            </div>
            @endforeach
        </div>
    </div>

    <!--div class="text-center text-blue-600 hover:underline cursor-pointer font-semibold mt-6">View all Localities</div-->
</div>


    
  
    
      </div> <!-- End of .flex-1 (main) -->
  <!-- Sidebar Ad -->
    <aside class="w-full lg:w-80 shrink-0 mt-8 lg:mt-0 lg:sticky top-24 h-fit">
      <div class="bg-white rounded-xl shadow-lg p-6 mb-8 flex flex-col items-center justify-center">
        <img src="/images/ad.png" alt="Ad" class="h-36 w-auto rounded-lg object-contain mb-4" />
        <div class="text-lg font-semibold text-gray-800 mb-2 text-center">
          Sell or rent faster at the right price!
        </div>
        <p class="text-gray-500 text-center mb-4">
          List your property now
        </p>
        <a href="/post-property" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg font-bold transition w-full text-center">
          Post Property, It's FREE
        </a>
      </div>
    </aside>
  </div>
</div>


</main>

<!-- Login Popup Modal -->
<div id="login-popup" class="fixed inset-0 bg-black bg-opacity-40 z-50 flex items-center justify-center hidden">
    <div class="bg-white rounded-lg p-8 shadow-lg w-full max-w-md text-center">
        <h3 class="text-xl font-bold mb-4 text-gray-900">Sign in to continue</h3>
        <p class="text-gray-700 mb-6">To like or save a property, please login or register for free.</p>
        <a href="{{ route('login') }}" class="bg-blue-600 text-white font-semibold px-6 py-2 rounded mr-2 hover:bg-blue-700 transition">Login</a>
        <a href="{{ route('register') }}" class="bg-gray-100 text-blue-600 font-semibold px-6 py-2 rounded hover:bg-gray-200 transition">Register</a>
        <button onclick="closeLoginPopup()" class="block mt-8 text-gray-500 hover:text-gray-800 mx-auto">Close</button>
    </div>
</div>

<script>
    function showLoginPrompt() {
        document.getElementById('login-popup').classList.remove('hidden');
    }

    function closeLoginPopup() {
        document.getElementById('login-popup').classList.add('hidden');
    }

function switchTab(type) {
    // Tab IDs
    const tabs = ['buy', 'rent', 'commercial'];

    tabs.forEach(tab => {
        const e = document.getElementById('tab-' + tab);
        if (tab === type) {
            // ACTIVE tab, show underline/bold color
            e.classList.add('border-blue-600', 'bg-gray-50', 'text-gray-700');
            e.classList.remove('text-gray-600', 'border-transparent');
        } else {
            // INACTIVE tabs, remove underline and dim
            e.classList.remove('border-blue-600', 'bg-gray-50', 'text-gray-700');
            e.classList.add('text-gray-600', 'border-transparent');
        }
        
         document.getElementById('property-type').value = type;
    });

    document.getElementById('property-type').value = type;

    // Update search placeholder (optional)
    const searchInput = document.getElementById('search-input');
    if (type === 'buy') {
        searchInput.placeholder = 'Search by Locality, Project, or Landmark...';
    } else if (type === 'rent') {
        searchInput.placeholder = 'Search for Rental Properties...';
    } else if (type === 'commercial') {
        searchInput.placeholder = 'Search for Offices, Shops, Warehouses...';
    }
}    
    
</script>

<footer class="bg-gray-800 text-white py-10">
    <div class="container mx-auto px-6">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
            <div>
                <h3 class="text-lg font-bold">RealtyCo</h3>
                <p class="mt-2 text-gray-400">Your trusted partner in finding the perfect property.</p>
            </div>
            <div>
                <h3 class="text-lg font-bold">Quick Links</h3>
                <ul class="mt-2 space-y-2">
                    <li><a href="#" class="text-gray-400 hover:text-white">About Us</a></li>
                    <li><a href="#" class="text-gray-400 hover:text-white">Properties</a></li>
                    <li><a href="#" class="text-gray-400 hover:text-white">Contact</a></li>
                </ul>
            </div>
            <div>
                <h3 class="text-lg font-bold">Contact Us</h3>
                <p class="mt-2 text-gray-400">Guwahati, Assam, India</p>
                <p class="text-gray-400">contact@realtyco.com</p>
            </div>
        </div>
    </div>
</footer>

<style>
.white-box {
  background-color: #fff;
  border-radius: 0.75rem;
  box-shadow: 0 10px 15px rgba(0,0,0,0.1);
  padding: 1.5rem;
}

.title-box .title {
  font-size: 1.5rem;
  font-weight: 700;
  margin-bottom: 1rem;
}

.service-tabs {
  display: flex;
  border-bottom: 2px solid #e5e7eb;
  margin-bottom: 1rem;
}

.service-tabs li {
  padding: 0.75rem 1.5rem;
  cursor: pointer;
  font-weight: 600;
  color: #6b7280;
  border-bottom: 4px solid transparent;
  transition: all 0.3s ease;
}

.service-tabs li.active,
.service-tabs li:hover {
  color: #6366f1;
  border-bottom-color: #6366f1;
}

.service-tab-list {
  display: none;
}

.service-tab-list.active {
  display: block;
}

.link {
  display: flex;
  align-items: center;
  gap: 1rem;
  color: #374151;
  text-decoration: none;
  font-weight: 600;
}

.link strong {
  font-weight: 700;
}

.corruptedImg {
  width: 79px;
  height: 79px;
  overflow: hidden;
}

.scrollbar-hide {
  -ms-overflow-style: none;
  scrollbar-width: none;
}

.scrollbar-hide::-webkit-scrollbar {
  display: none;
}

.service-tabs {
  display: flex;
  gap: 1rem; /* spacing between tabs, optional */
  padding-left: 0;
  margin: 0;
  list-style: none;
}

.service-tabs li {
  cursor: pointer;
  padding: 0.5rem 1rem;
  font-weight: 600;
  color: #4b5563; /* gray */
  border-bottom: 2px solid transparent;
  transition: color 0.3s ease, border-color 0.3s ease;
}

.service-tabs li.active,
.service-tabs li:hover {
  color: #4338ca; /* indigo-700 */
  border-bottom-color: #4338ca;
}

</style>

<script>
 
document.addEventListener('DOMContentLoaded', function () {
  var swiper = new Swiper('.myCitySwiper', {
    slidesPerView: 4,
    spaceBetween: 24,
    loop: true,
    autoplay: {
      delay: 1600,
      disableOnInteraction: false,
    },
    /*pagination: {
      el: '.swiper-pagination',
      clickable: true,
    },
    navigation: {
      nextEl: '.swiper-button-next',
      prevEl: '.swiper-button-prev',
    },*/
    breakpoints: {
      640: { slidesPerView: 2 },
      1024: { slidesPerView: 4 },
      1280: { slidesPerView: 6 }
    }
  });
});

  
 // Tab functionality
    document.querySelectorAll('[role="tab"]').forEach(button => {
      button.addEventListener('click', () => {
        const parent = button.closest('ul');
        parent.querySelectorAll('button').forEach(btn => {
          btn.classList.remove('text-indigo-600', 'border-indigo-600');
          btn.classList.add('text-gray-600', 'border-transparent');
          btn.setAttribute('aria-selected', false);
        });
        button.classList.add('text-indigo-600', 'border-indigo-600');
        button.classList.remove('text-gray-600', 'border-transparent');
        button.setAttribute('aria-selected', true);

        const tabPanelContainer = button.closest('div').querySelectorAll('[role="tabpanel"]');
        tabPanelContainer.forEach(panel => panel.classList.add('hidden'));
        const target = document.querySelector(button.dataset.tabTarget);
        target.classList.remove('hidden');
      });
    });


document.addEventListener('DOMContentLoaded', function () {
  var swiper = new Swiper('.mySwiper', {
    slidesPerView: 2,
    spaceBetween: 40,
    loop: true,
    autoplay: {
      delay: 2500,
      disableOnInteraction: false,
    },
    pagination: {
      el: '.swiper-pagination',
      clickable: true,
    },
    /*navigation: {
      nextEl: '.swiper-button-next',
      prevEl: '.swiper-button-prev',
    },*/
  });
});


</script>



</body>
</html>

